package gov.va.vinci.dart.db;

import java.util.List;


import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.DartRequest;

public interface DartRequestDAO {

	void save(final DartRequest request);
	DartRequest findById(final int requestId) throws ObjectNotFoundException;
	List<DartRequest> listByActivityId(final int activityId);
	List<DartRequest> listByRequestor(final int requestorId);
	List<DartRequest> listAll();
	List<DartRequest> listRecentByRequestor(final int requestorId, final int maxResults);
	List<DartRequest> listByName(final int requestorId, final String key);
	List<DartRequest> listAllButInitiated();
	List<DartRequest> listAllSubmitted();
	DartRequest findMostRecentAmendment(final int headId);
}